clear();
clc();
close all;                              						%Plots schließen

%KONFIGURATION---------------------------------------------------------------------
x                   = -2:0.0001:2.0;                            %Diagrammbereich:    %Syntax: links: for-Startwert; Mitte = for-Inkrement; rechts: for-Abbruchbedingung
y                   = @(x) 600*x.^4-550*x.^3+200*x.^2-20*x-1;   %Funktion:           %Syntax: Beispiel: y = @(x) x.^3-5*x+3; exponenten mit ".^", statt "^" schreiben; Schreibe "5*x", statt "5x"
y_                  = @(x) 2400*x.^3-1650*x.^2+400*x.^1-20;
Xi                  = 0.0;                                      %Modus Startwert: Startwert Xi
Xu                  = 0.1;                                      %Modus Intervall: Untere Grenze neben Nullstelle: aus Plot ablesen
Xo                  = 1.0;                                      %Modus Intervall: Untere Grenze neben Nullstelle: aus Plot ablesen
Modus               = 3;                                        %1 = Modus Intervall - Abbruchbedingung: exakte Nullstelle
                                                                %2 = Modus Intervall - Abbruchbedingung: Nachkommastelle
                                                                %3 = Modus Intervall - Abbruchbedingung: relativer Fehler 
                                                                %4 = Modus Startwert - Abbruchbedingung: exakte Nullstelle
                                                                %5 = Modus Startwert - Abbruchbedingung: Nachkommastelle
                                                                %6 = Modus Startwert - Abbruchbedingung: relativer Fehler                                     
Nachkommastelle     = 3;
Relativer_Fehler    = 10^-4;                                    %Angabe nicht in Prozent sondern dezimal -> Maximum ist 1
sKommastellenDouble = '%.8f';                                   %Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen

%FUNKTIONSPLOT---------------------------------------------------------------------
xACHSE          = @(x) 0*x;
plot(x,y(x),'color','blue');
hold on;                                                                            %Warten bis zur Plotausgabe
plot(x,xACHSE(x),'color','black');
grid on;
grid minor;

%EINGABEBEREICH--------------------------------------------------------------------
fprintf('%s\n',"Tragen Sie die Funktion in den Header des Skriptes ein!")
fprintf('%s\n',"Tragen Sie die Ableitung der Funktion in den Header des Skriptes ein!")
fprintf('%s\n',"Betrachten Sie den Plot der Funktion!")
fprintf('%s\n',"Wählen Sie eine Nullstelle um die sie eine Grenze ziehen möchten!")
fprintf('%s\n\n',"__________________________________________________________________");

%BERECHNUNG------------------------------------------------------------------------
aTABELLE=["i","Xi","Xi+1"];                                                         %Kopfzeile Mixed-Array

switch(Modus)
    case 1
        Xi=((Xo-Xu)/2)+Xu;
        %---------------------
        %Das ist vernünftig: 
        y_X0=y_(Xi);
        %---------------------
        %Das ist unvernünftig:
        %dx=0.00000001;
        %y_X0=(y(Xi+dx)-y(Xi))/dx;
        %---------------------
        i=0;
        while(1)
            aTABELLE(i+2,1)=i;
            aTABELLE(i+2,2)=num2str(Xi,sKommastellenDouble);
            aTABELLE(i+2,3)=num2str(Xi-(y(Xi)/y_X0),sKommastellenDouble);
            if(aTABELLE(i+2,2) == aTABELLE(i+2,3))
                break;
            end 
            Xi=str2double(aTABELLE(i+2,3));
            i=i+1;
        end
        fprintf('%s\n',"Berechnung abgebrochen, weil Xi=Xi+1");
        
    case 2
        Xi=((Xo-Xu)/2)+Xu;
        %---------------------
        %Das ist vernünftig: 
        y_X0=y_(Xi);
        %---------------------
        %Das ist unvernünftig:
        %dx=0.00000001;
        %y_X0=(y(Xi+dx)-y(Xi))/dx;
        %---------------------
        i=0;
        while(1)
            aTABELLE(i+2,1)=i;
            aTABELLE(i+2,2)=num2str(Xi,sKommastellenDouble);
            aTABELLE(i+2,3)=num2str(Xi-(y(Xi)/y_X0),sKommastellenDouble);
            if(abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))) <= (1/(10^Nachkommastelle)))
                break;
            end 
            Xi=str2double(aTABELLE(i+2,3));
            i=i+1;
        end
        switch(Nachkommastelle)
            case 0     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.0f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));
            case 1     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.1f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));
            case 2     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.2f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));       
            case 3     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.3f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));                        
            case 4     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.4f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));                        
            case 5     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.5f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));                       
            case 6     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.6f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));                        
            case 7     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.7f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));        
            case 8     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.8f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));     
            case 9     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.9f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));                        
            case 10     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.10f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));                        
            case 11     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.11f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));                        
            case 12     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.12f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));                       
            case 13     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.13f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));        
            otherwise
                 fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.21f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));        
        end
        
    case 3
        Xi=((Xo-Xu)/2)+Xu;
        %---------------------
        %Das ist vernünftig: 
        y_X0=y_(Xi);
        %---------------------
        %Das ist unvernünftig:
        %dx=0.00000001;
        %y_X0=(y(Xi+dx)-y(Xi))/dx;
        %---------------------
        i=0;
        while(1)
            aTABELLE(i+2,1)=i;
            aTABELLE(i+2,2)=num2str(Xi,sKommastellenDouble);
            aTABELLE(i+2,3)=num2str(Xi-(y(Xi)/y_X0),sKommastellenDouble);
            if(abs((str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,2)))/str2double(aTABELLE(i+2,3))) < abs(Relativer_Fehler))
                break;
            end 
            Xi=str2double(aTABELLE(i+2,3));
            i=i+1;
        end
        fprintf('Berechnung abgebrochen, weil |(Xi-Xi_alt)/Xi| kleiner als |zulässiger relativer Fehler| %f < %f\n',abs(((str2double(aTABELLE(i+2,3)) - str2double(aTABELLE(i+2,2)))/str2double(aTABELLE(i+2,3)))),abs(Relativer_Fehler));
        
    case 4
        %---------------------
        %Das ist vernünftig: 
        y_X0=y_(Xi);
        %---------------------
        %Das ist unvernüftig:
        %dx=0.00000001;
        %y_X0=(y(Xi+dx)-y(Xi))/dx;
        %---------------------
        i=0;
        while(1)
            aTABELLE(i+2,1)=i;
            aTABELLE(i+2,2)=num2str(Xi,sKommastellenDouble);
            aTABELLE(i+2,3)=num2str(Xi-(y(Xi)/y_X0),sKommastellenDouble);
            if(aTABELLE(i+2,2) == aTABELLE(i+2,3))
                break;
            end 
            Xi=str2double(aTABELLE(i+2,3));
            i=i+1;
        end
        fprintf('%s\n',"Berechnung abgebrochen, weil Xi=Xi+1");
        
    case 5
        %---------------------
        %Das ist vernünftig: 
        y_X0=y_(Xi);
        %---------------------
        %Das ist unvernünftig:
        %dx=0.00000001;
        %y_X0=(y(Xi+dx)-y(Xi))/dx;
        %---------------------
        i=0;
        while(1)
            aTABELLE(i+2,1)=i;
            aTABELLE(i+2,2)=num2str(Xi,sKommastellenDouble);
            aTABELLE(i+2,3)=num2str(Xi-(y(Xi)/y_X0),sKommastellenDouble);
            if(abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))) <= (1/(10^Nachkommastelle)))
                break;
            end 
            Xi=str2double(aTABELLE(i+2,3));
            i=i+1;
        end
        switch(Nachkommastelle)
            case 0     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.0f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));
            case 1     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.1f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));
            case 2     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.2f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));       
            case 3     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.3f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));                        
            case 4     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.4f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));                        
            case 5     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.5f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));                       
            case 6     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.6f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));                        
            case 7     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.7f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));        
            case 8     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.8f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));     
            case 9     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.9f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));                        
            case 10     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.10f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));                        
            case 11     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.11f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));                        
            case 12     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.12f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));                       
            case 13     
                fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.13f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));        
            otherwise
                 fprintf('Genauigkeit für %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.21f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,2))-str2double(aTABELLE(i+2,3))));        
        end

    case 6
        %Das ist vernünftig: 
        y_X0=y_(Xi);
        %---------------------
        %Das ist unvernünftig:
        %dx=0.00000001;
        %y_X0=(y(Xi+dx)-y(Xi))/dx;
        %---------------------
        i=0;
        while(1)
            aTABELLE(i+2,1)=i;
            aTABELLE(i+2,2)=num2str(Xi,sKommastellenDouble);
            aTABELLE(i+2,3)=num2str(Xi-(y(Xi)/y_X0),sKommastellenDouble);
            if(abs((str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,2)))/str2double(aTABELLE(i+2,3))) < abs(Relativer_Fehler))
                break;
            end 
            Xi=str2double(aTABELLE(i+2,3));
            i=i+1;
        end
        fprintf('Berechnung abgebrochen, weil |(Xi-Xi_alt)/Xi| kleiner als |zulässiger relativer Fehler| %f < %f\n',abs(((str2double(aTABELLE(i+2,3)) - str2double(aTABELLE(i+2,2)))/str2double(aTABELLE(i+2,3)))),abs(Relativer_Fehler));
       
    otherwise
        fprintf('%s\n','Variable "Modus" nicht definiert!');
end

%AUSGABE---------------------------------------------------------------------------
fprintf('%s\n\n',"__________________________________________________________________");
disp(aTABELLE);

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aTABELLE                                                          %Workspace aufräumen